using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class planete : MonoBehaviour {
	
	// gameobject couche planete
	public 	 int 			id_level;
	public	 GameObject 	planette;
	public	 GameObject[] 	couches;
	public	 GameObject[] 	demi_couches;
	// liste des positions pour la création des props
	public  Transform 		emptyAllpropsPos;
	// GameObject props
	public List<GameObject> _PropsGameObject = new List<GameObject>();
	public Material			materialPorps;
	public Material			materialIlluPorps;
	public Color[]			propsColor;
	// GameoBject empty pour la rotation de la caméra
	public	 GameObject 	dummy_camera;	
	public	 GameObject 	mainCamera;
	
	// couleur planete
	public Color[] planettes_colors_princ;
	public Color[] planettes_colors_sec;
	public Color[] planettes_colors_mine;
	
	// particules 
	public	 GameObject 	particleCreuse;
	public	 GameObject 	particleMinerais;
	public	 GameObject 	coeurPlanette;
	private	 GameObject 	particleInstance;
	//tirs sur planete
	public	 GameObject 	meteor;
	// layer GameObject destructibles
	public	 LayerMask 		destructibleLayer;
	// variable de vistesse rotation de la planete
	private	 float 			speedRotation = 0.4f;
	// hauteur / largeur écran pour GUI
	private	 float 			screenWidth;
	private	 float 			screenHeight;	
	public	 string 		etat = "start";
	// Variables de test
	private	 string 		cacheEtat;
	private	 string 		cacheTriangle = " ";
	private	 string 		coucheEnCreation;
	private	 Vector2 		startMousePosition;
	private	 Vector3 		offsetMousePos;
	// variable arme selectionnée
	public string 			weaponUse = "METEOR01";
	
	// Liste de tous les élements destructibles
	public List<GameObject> _Allprops = new List<GameObject>();
	
	// variable cache pour activer le lancement d'un météor
	private int 			cacheStock;
	
	// GUI
	public GUISkin			customSkin; 
	public GUIStyle 		weapon01Style;
	public GUIStyle 		headerStyle;
	
	public Texture[] 		textureIconeWeapon01;
	public Texture[] 		textureIconeWeapon02;
	public Texture[] 		textureIconeWeapon03;
	
	private Texture 		etatIconeWeapon01;
	private Texture 		etatIconeWeapon02;
	private Texture 		etatIconeWeapon03;
	
	public Texture 			icoMenu;
	public Texture 			icoReprendre;
	public Texture			icoQuit;
	public GUITexture 		icoSplash01;
	public GUITexture 		icoSplash02;
	
	public GUITexture		fondOpacity;
	private float 			iconeXpos 	= -100.0f;
	private float 			startTimer;
	public  float 			startTimerCreuse;
	
	// variables récupérées du playerPref;
	private int stockWeapon01 = 999;
	private int stockWeapon02;
	private int stockWeapon03;
	
	private int gameScore = 0;
	
	
	// Use this for initialization
	void Start () {		
		screenWidth = Screen.width;
		screenHeight = Screen.height;
		texturingSurface();				// texture la première couche de la terre
		instanceCouches();				// création des couches inférieures
		createProps();					//création des props à la surface
		statesButton(01);				// active la meteor 01 par défaut
		getDatabase();					// charger les playerprefs
		fondOpacity.color =  new Color(fondOpacity.color.r,fondOpacity.color.g,fondOpacity.color.b, 0.35f);
		startTimer = Time.time;
		
		materialPorps.color		=	propsColor[id_level];
		materialIlluPorps.color	=	planettes_colors_mine[id_level];
		
	}
	
	// Update is called once per frame
	void Update () {
		
		switch(etat){
			case("start") 			: UpdateStart(); 		break;
			case ("explode")		: UpdateExplose(); 		break;
			case ("init_creuse") 	: UpdateInitCreuse(); 	break;
			case ("creuse") 		: UpdateCreuse(); 		break;
			case ("end")			: UpdateEnd(); 			break;
		}
		
	}
	
	void OnGUI(){
		
		GUI.skin = customSkin;
		
		switch(etat){
			case "explode"			: GUIexplose();	GUImenu();	GUIScore(); break;
			case "creuse" 			: GUImenu();	GUIScore(); 			break;
			case "pause" 			: GUIpause(); 				GUIScore(); break;
			case "end"				: GUIend(); 	GUImenu();				break;
		}		
	}
	
	//------------ Bases de données	----------------------------------------------------------------
	
	void getDatabase(){ //copie les données de jeu existantes
			
		gameScore = 0;
		stockWeapon02 = PlayerPrefs.GetInt("weapons_2");
		stockWeapon03 = PlayerPrefs.GetInt("weapons_3");

	}
	
	void setDatabase(){ // sauvegarde les données sur la machine
			
		PlayerPrefs.SetInt("minerals_count_begining", gameScore + PlayerPrefs.GetInt("minerals_count_begining") );
		PlayerPrefs.SetInt("minerals_count", gameScore + PlayerPrefs.GetInt("minerals_count"));
		PlayerPrefs.SetInt("weapons_2", stockWeapon02);
		PlayerPrefs.SetInt("weapons_3", stockWeapon03);
				
		switch ( id_level ){
		case 0:
			if( gameScore > PlayerPrefs.GetInt("score_1") ) PlayerPrefs.SetInt("score_1", gameScore);
			break;
		case 1:
			if( gameScore > PlayerPrefs.GetInt("score_2") ) PlayerPrefs.SetInt("score_2", gameScore);
			break;
		case 2:
			if( gameScore > PlayerPrefs.GetInt("score_3") ) PlayerPrefs.SetInt("score_3", gameScore);
			break;
		case 3:
			if( gameScore > PlayerPrefs.GetInt("score_4") ) PlayerPrefs.SetInt("score_4", gameScore);
			break;
		case 4:
			if( gameScore > PlayerPrefs.GetInt("score_5") ) PlayerPrefs.SetInt("score_5", gameScore);
			break;
		}
	
	}
	
	
	//----------------------------------------------------------------------
	// lancement de la partie explosion


	void UpdateStart()
	{	
		// affcihe le splash screen 01
		popUpSplash(icoSplash01, true);
		fadeInOut(true, 0.35f);
		if( Time.time > 3.5f + startTimer ){
			etat = "explode";
			GameObject.Find ("loader").GetComponent<loader_script>().is_active = true;
		}
	}
	
	void UpdateExplose()
	{
		activeRotatePlanette();			// rotation de la planette
		Zoom();							// zoom camera
		tirScript();
		popUpSplash(icoSplash01, false);
		fadeInOut(false, 0);
	}
	
	void UpdateInitCreuse()
	{	
		GameObject.Find ("loader").GetComponent<loader_script>().is_active = false;
		fadeInOut(true, 0.2f);
		popUpSplash(icoSplash02, true);
		if(Time.time > startTimerCreuse + 2.5f)
		{
			etat = "creuse";
		}
	}
	
	void UpdateCreuse()
	{
		activeRotatePlanette();			// rotation de la planette
		Zoom();							// zoom camera
		creusePlanette();				// autorise la creusage de la planette
		coeurPlanete();					// script le coeur de la planette
		popUpSplash(icoSplash02, false);
		fadeInOut(false, 0);
		GameObject.Find ("loader").GetComponent<loader_script>().is_active = true;	// réactive le chrono

	}
	
	void UpdateEnd()
	{
	}
	
	//------------ Bloc Texturing de la première couche de la planette 		----------------------------------------------------------------
	
	void texturingSurface(){
		
		// boucle parmi les couches de la planette
		for (int i = 0; i < 5; i++)
		{
			// boucle pour les enfants de chaque couche de la planette 
			foreach ( Transform child in demi_couches[i].transform)
			{
				//creation colider pour la couche de surface
				if(i <2)
				{
					if(Random.Range(0,100)> 50)
					{
						child.gameObject.renderer.material.color = planettes_colors_princ[id_level];
					}else
					{
						child.gameObject.renderer.material.color = planettes_colors_sec[id_level];
					}		
				}
				// assignation material couche 01
				if(i == 2 || i == 3)
				{
					if(Random.Range(0,100) > 50)
					{
						child.gameObject.renderer.material.color = planettes_colors_princ[id_level];
					}else{
						child.gameObject.renderer.material.color = planettes_colors_sec[id_level];
					}
					if(Random.Range(0,100) < 27)
					{
						child.gameObject.renderer.material = materialIlluPorps;
						child.gameObject.renderer.material.color = planettes_colors_mine[id_level];
					}						
				}
				//------------------
				
				// assignation material couche 02
				if(i == 4 || i == 5)
				{
					if(Random.Range(0,100) > 50)
					{
						child.gameObject.renderer.material.color = planettes_colors_princ[id_level];
					}else{
						child.gameObject.renderer.material.color = planettes_colors_sec[id_level];
					}
					
					if(Random.Range(0,100) < 45)
					{
						child.gameObject.renderer.material = materialIlluPorps;
						child.gameObject.renderer.material.color = planettes_colors_mine[id_level];
					}				
				}
			}
		}		
	}
	//-----------------------------------------------------------------------------------------------------------------------------------------------
	//------------ Bloc création des props sur la planette 		-------------------------------------------------------------------------------------
	void createProps()
	{	
		// parcour la liste des positions
		foreach( Transform propsDummy in emptyAllpropsPos ){
			int randomProps = Random.Range(0, _PropsGameObject.Count);
			GameObject newProps = Instantiate( _PropsGameObject[ randomProps ], propsDummy.position, propsDummy.rotation) as GameObject;
			//newProps.transform.parent = emptyAllpropsPos;
			newProps.transform.localPosition = new Vector3( newProps.transform.localPosition.x * 1f, newProps.transform.localPosition.y * 1f, newProps.transform.localPosition.z * 1f);
			newProps.transform.Rotate( new Vector3(180,0,0));
			newProps.GetComponent<hv_script>().totalHealthPoint = id_level + 3;			
			_Allprops.Add(newProps);
		}
	}
		
	//----------------------------------------------------------------------------------------------------------------------------------------------
	//------------ Bloc action Tirer sur la planete 		----------------------------------------------------------------------------------------
	void tirScript(){
		if(Input.GetMouseButtonDown(0))
		{
			//TirDown();
		}
		if(Input.GetMouseButtonUp(0))
		{
			TirUp();
		}
		iconeXpos = Mathf.Lerp( iconeXpos, 50.0f, Time.deltaTime * 2.5f);
	}
	
	void TirDown(){
		Ray ray = mainCamera.camera.ScreenPointToRay(Input.mousePosition);
   		RaycastHit hit;
    	if (Physics.Raycast(ray, out hit))
		{	
			cacheTriangle = hit.transform.name;
		}		
		
	}
	
	void TirUp()
	{
		Ray ray = mainCamera.camera.ScreenPointToRay(Input.mousePosition);
   		RaycastHit hit;
    	if (Physics.Raycast(ray, out hit))
		{	 
			// layer 8 = indestructible // layer 9 = destructible
			if(hit.transform.gameObject.layer == 9 || hit.transform.gameObject.layer == 8 )
			{
				switch( weaponUse )
				{
					case "METEOR01": cacheStock = stockWeapon01; break;
					case "METEOR02": cacheStock = stockWeapon02; if(stockWeapon02 > 0) stockWeapon02--; break;
					case "METEOR03": cacheStock = stockWeapon03; if(stockWeapon03 > 0) stockWeapon03--; break;
				}
				if( cacheStock > 0)
				{
					Vector3 posInstanceMeteor = hit.point * 4.0f;
					GameObject newMeteor = Instantiate( meteor, posInstanceMeteor, Quaternion.identity) as GameObject;
					newMeteor.GetComponent<meteor>().targetTransform = hit.point;
				}
			}
		}
	}
	
	// calcul le rayon des epxlosions 
	private float rayonInpact;
	private int   puissanceWeapon;
	public void explosionImpact(Vector3 positionExplosion, string weaponType)
	{
		switch( weaponType )
		{
			case "METEOR01": rayonInpact = 1.5f; puissanceWeapon = 1;	break;
			case "METEOR02": rayonInpact = 2.7f; puissanceWeapon = 4; 	break;
			case "METEOR03": rayonInpact = 6.5f; puissanceWeapon = 8; 	break;
		}
		
		foreach( GameObject props in _Allprops )
		{
			float distanceExplosion = Vector3.Distance( positionExplosion, props.transform.position);
			if( distanceExplosion < rayonInpact)
			{
				props.GetComponent<hv_script>().upDateHealthPoint(puissanceWeapon);
			}
		}
	}
	
	
	//------------------------------------------------------------------------------------------------------------------------------------------------
	//------------ Bloc creuse planette 		------------------------------------------------------------------------------------------------------
	
	
	void creusePlanette()
	{		
		if(Input.GetMouseButtonDown(0))
		{
			CreuseDown();
		}
		if(Input.GetMouseButtonUp(0))
		{
			CreuseUp();
		}		
	}
	
	void CreuseDown()
	{
		Ray ray = mainCamera.camera.ScreenPointToRay(Input.mousePosition);
   		RaycastHit hit;
    	if (Physics.Raycast(ray, out hit)){
			cacheTriangle = hit.transform.name;
		}	
	}
	
	void CreuseUp()
	{
		Ray ray = mainCamera.camera.ScreenPointToRay(Input.mousePosition);
   		RaycastHit hit;
    	if (Physics.Raycast(ray, out hit)){
			if(hit.transform.name == cacheTriangle && cacheTriangle != " " && hit.transform.gameObject.layer == 9)
			{	
				Color targetColor = hit.transform.gameObject.renderer.material.color;				
				// intance des particules à la desturction d'un triangle
				
				if(hit.transform.gameObject.renderer.material.name == "triangle_principale (Instance)" || hit.transform.gameObject.renderer.material.name == "triangle_secondaire (Instance)"){
					particleInstance = particleCreuse;
				}
				else if(hit.transform.gameObject.renderer.material.name == "HV_01_main (Instance) (Instance)"){
					particleInstance = particleMinerais;
					gameScore += 100;
				}
				
				GameObject instanceParticle = (GameObject) Instantiate( particleInstance, (hit.point - (hit.point /10.0f)) , Quaternion.identity) as  GameObject;
				instanceParticle.particleEmitter.localVelocity = hit.point * 0.4f;				
				
				//  --- A supprimer pour une version mobile
				if(particleInstance == particleCreuse)
				{
					ParticleAnimator particleAnimator = instanceParticle.GetComponent<ParticleAnimator>();	
					Color[] modifiedColors = particleAnimator.colorAnimation;
	        		
					for (int i = 0; i < 5; i++){
						if( i == 1){
							targetColor.a = 1.0f;
						}
						else if( i == 2){
							targetColor.a = 0.8f;
						}
						else if( i == 3){
							targetColor.a = 0.5f;
						}
						else if( i == 4){
							targetColor.a = 0.2f;
						}	
						modifiedColors[i] = targetColor;
					}
	        		particleAnimator.colorAnimation = modifiedColors;
				}
				// ---------------------------
				Destroy(hit.transform.gameObject);
			}
		}
	}	
	//------------------------------------------------------------------------------------------------------------------------------------------------	
	//------------ Bloc rotation planette 		-------------------------------------------------------------------------------------------------------

	void activeRotatePlanette(){
		
		// clic droit
    	if (Input.GetMouseButtonDown(1))
		{
			initRotationPlanette();
		}	
		if (Input.GetMouseButton(1))
		{
			rotatePlanette( Input.mousePosition.x, Input.mousePosition.y);
		}else{
			rotateEasePlanete();
		}
		
		// clic mollette
		if (Input.GetMouseButtonDown(2))
		{
			initRotationPlanette();
		}	
		if (Input.GetMouseButton(2))
		{
			rotatePlanette( Input.mousePosition.x, Input.mousePosition.y);
		}else{
			rotateEasePlanete();
		}
		
		
	}
	
	void initRotationPlanette()
	{
		startMousePosition = Input.mousePosition;
	}
	
	void rotatePlanette( float MouseX, float MouseY)
	{				
		offsetMousePos = new Vector3(-(MouseY - startMousePosition.y), MouseX - startMousePosition.x, 0); 
		speedRotation = Vector2.Distance(startMousePosition, offsetMousePos) / screenWidth * 0.2f;
		dummy_camera.transform.Rotate( offsetMousePos * speedRotation * Time.deltaTime);	
	}
	
	void rotateEasePlanete()
	{	
		speedRotation = Mathf.Lerp(speedRotation, 0.005f, Time.deltaTime * 1.5f);
		dummy_camera.transform.Rotate( offsetMousePos * speedRotation * Time.deltaTime);	
	}
	//------------------------------------------------------------------------------------------------------------------------------------------------	
	// bloc zoom camera --------------------------------------------------------------------------------------------------------------------
		
	void Zoom()
	{	
  		if ( Input.GetAxis("Mouse ScrollWheel") < 0.0f )
		{
			if( mainCamera.transform.localPosition.z > -26.6f ) ZoomOut();
  		}
  		else if ( Input.GetAxis("Mouse ScrollWheel") > 0.0f )
		{
			if( mainCamera.transform.localPosition.z < -13)  ZoomIn();
  		}
	}
	void ZoomOut()
	{
		mainCamera.transform.Translate(Vector3.back * Time.deltaTime * 50.0f);
	}
	void ZoomIn()
	{
		mainCamera.transform.Translate(Vector3.forward * Time.deltaTime * 50.0f);
	}
	
	// -----------------------------------------------------------------------------------------------------------------------------------
	//------------ Création des couches de la planette 	----------------------------------------------------------------------------------
	
	void instanceCouches()
	{	
		Instantiate(couches[0], new Vector3(0,0,0), Quaternion.identity);
		Instantiate(couches[1], new Vector3(0,0,0), Quaternion.identity);
	}	
	
	//------------------------------------------------------------------------------------------------------------------------------------------------	
	//------------ Rotation du coeur de la planette  	-------------------------------------------------------------------------------------------------------
	
	void coeurPlanete()
	{
		Vector3 VrotateCoeur = new Vector3( 10.0f,10.0f,10.0f);
		coeurPlanette.transform.Rotate( VrotateCoeur * Time.deltaTime * 2.0f);
	}
	
	// FadeIn / out du fond noir pour le menu 
	void fadeInOut(bool actif, float opacity)
	{	
		if(actif) fondOpacity.color = Color.Lerp( fondOpacity.color, new Color(fondOpacity.color.r, fondOpacity.color.g, fondOpacity.color.b, opacity), Time.deltaTime * 3f);
		else  	  fondOpacity.color = Color.Lerp( fondOpacity.color, new Color(fondOpacity.color.r, fondOpacity.color.g, fondOpacity.color.b, 0), Time.deltaTime * 3f);
	}
	
	void popUpSplash(GUITexture splash, bool actif)
	{
		if(actif) splash.color = Color.Lerp( splash.color, new Color(splash.color.r, splash.color.g, splash.color.b, 0.4f), Time.deltaTime * 2.5f);
		else  	  splash.color = Color.Lerp( splash.color, new Color(splash.color.r, splash.color.g, splash.color.b, 0), Time.deltaTime * 2.5f);
	}	

	/////////////-- GUI	    //////////////////////////////////////////////////////////////////////////////	
	void GUIexplose(){
		// icones selection des armes
		// 01 -------------------------------------------------------------------------------------
		if (GUI.Button(new Rect( iconeXpos, screenHeight/2 - 180 , 80, 80), etatIconeWeapon01))
		{
			weaponUse = "METEOR01";
			statesButton(01);
		}
		GUI.Label(new Rect( iconeXpos, screenHeight/2 - 90 , 80, 20), "Unlimited",weapon01Style);
		
		// 02 -------------------------------------------------------------------------------------
		if (GUI.Button(new Rect( iconeXpos, screenHeight/2 - 40, 80, 80), etatIconeWeapon02))
		{
			if( stockWeapon02 > 0)
			{
				weaponUse = "METEOR02";
				statesButton(02);
			}else
			{
				weaponUse = "METEOR01";
				statesButton(01);
			}
		}	
		GUI.Label(new Rect( iconeXpos, screenHeight/2 + 50 , 80, 20), "Stock: "+stockWeapon02.ToString(),weapon01Style);

		// 03 -------------------------------------------------------------------------------------
		if (GUI.Button(new Rect( iconeXpos, screenHeight/2 + 100, 80, 80), etatIconeWeapon03))
		{
			if( stockWeapon03 > 0)
			{
				weaponUse = "METEOR03";
				statesButton(03);
			}else
			{
				weaponUse = "METEOR01";
				statesButton(01);
			}
		}
		GUI.Label(new Rect( iconeXpos, screenHeight/2 + 190 , 80, 20), "Stock: "+stockWeapon03.ToString(),weapon01Style);
	}
	
	void statesButton(int buttonId)
	{
		etatIconeWeapon01 = textureIconeWeapon01[0];
		etatIconeWeapon02 = textureIconeWeapon02[0];
		etatIconeWeapon03 = textureIconeWeapon03[0];
		
		switch( buttonId )
		{
			case 01: etatIconeWeapon01 = textureIconeWeapon01[1]; break;
			case 02: etatIconeWeapon02 = textureIconeWeapon02[1]; break;
			case 03: etatIconeWeapon03 = textureIconeWeapon03[1]; break;
		}
	}

	void GUIend()
	{		
		fadeInOut(true, 0.35f);
		GUI.Label(new Rect( screenWidth/2 - 50, screenHeight/2 - 50 , 100, 40), "Score: "+ gameScore.ToString(), headerStyle);
		if (GUI.Button(new Rect( screenWidth/2 - 25, screenHeight/2 + 60 , 50, 40), icoQuit))
		{
			setDatabase();
			Application.LoadLevel("menu");
		}
	}
	
	void GUImenu()
	{
		if (GUI.Button(new Rect(screenWidth - 80, 40, 50, 40), icoMenu))
		{
			cacheEtat = etat;
			etat = "pause";
			GameObject.Find ("loader").GetComponent<loader_script>().is_active = false;

		}	
	}
	
	void GUIpause()
	{		
		if (GUI.Button(new Rect( screenWidth/2 - 25, screenHeight/2 + 30 , 50, 40), icoQuit))
		{
			setDatabase();
			Application.LoadLevel("menu");
		}
		
		if (GUI.Button(new Rect( screenWidth/2 - 25, screenHeight/2 - 30 , 50, 40), icoReprendre))
		{
			etat = cacheEtat;
			GameObject.Find ("loader").GetComponent<loader_script>().is_active = true;

		}
		fadeInOut(true, 0.4f);
	}
	
	void GUIScore()
	{
		GUI.Label(new Rect( 50, 80 , 80, 20), "Minerals: " + gameScore.ToString(), headerStyle);
	}
}